SELECT
  b.Bestellingsnr,
  l.Omschrijving AS Leverancier,
  b.Omschrijving,
  r.Naam AS Relatienaam,
  b.Werknr,
  w.Omschrijving AS Werkomschrijving,
  CASE
    WHEN (b.Leverdatum)<Current_date THEN '<font color="red">' + FORMATDATETIME(b.Leverdatum,'dd-mm-yyyy')+'</font>'
	WHEN (b.Leverdatum)=Current_date THEN '<font color="orange">' + FORMATDATETIME(b.Leverdatum,'dd-mm-yyyy')+'</font>'
    WHEN (b.Leverdatum)>Current_date THEN '<font color="green">' + FORMATDATETIME(b.Leverdatum,'dd-mm-yyyy')+'</font>'
  END AS HTMLLeverdatum,    
  CASE
    WHEN (b.RecordStatus = 10)  THEN 'Nieuw'
    WHEN (b.RecordStatus = 15)  THEN 'Gemaild'
    WHEN (b.RecordStatus = 20)  THEN 'Verzonden'
    WHEN (b.RecordStatus = 30)  THEN 'Bevestigd'
    WHEN (b.RecordStatus = 40)  THEN 'Backorder'
    WHEN (b.RecordStatus = 50)  THEN 'Ontvangen'
    WHEN (b.RecordStatus = 60)  THEN 'Gefactureerd'
    WHEN (b.RecordStatus = 70)  THEN 'Geannuleerd'
    WHEN (b.RecordStatus = 999) THEN 'Vervallen'
    ELSE 'Onbekende recordstatus'
  END AS Bestelstatus
FROM "Bestellingen" b
INNER JOIN "ENKData"."Leveranciers" l ON (l.Leverancierscode=b.Leverancier)
LEFT JOIN "Werken" w ON (w.Werknr=b.Werknr)
LEFT JOIN "Relaties" r ON (r.Relatienr=w.Relatienr)
WHERE (b.RecordStatus<999)
ORDER BY Bestelstatus DESC, b.Leverdatum